﻿namespace Marimo.開発支援.コンソールアプリケーションライブラリ
{
    /// <summary>
    /// コマンドライン引数として指定されるコマンドの種類をあらわすクラスです。
    /// </summary>
    public class コマンド
    {
        /// <summary>
        /// コマンドクラスのインスタンスを生成します。
        /// </summary>
        /// <param name="コマンドキー">コマンドラインで指定されるコマンドから先頭のハイフン、スラッシュを除いたもの。</param>
        public コマンド(string コマンドキー)
        {
            エイリアスリスト = new string[0];
            this.コマンドキー = コマンドキー;
        }

        /// <summary>
        /// コマンドクラスのインスタンスを生成します。
        /// </summary>
        /// <param name="コマンドキー">コマンドラインで指定されるコマンドから先頭のハイフン、スラッシュを除いたもの。</param>
        /// <param name="必須である">このコマンドを指定することが必須である。</param>
        public コマンド(string コマンドキー, bool 必須である)
            : this(コマンドキー)
        {
            this.必須である = 必須である;
        }

        /// <summary>
        /// コマンドクラスのインスタンスを生成します。
        /// </summary>
        /// <param name="コマンドキー">コマンドラインで指定されるコマンドから先頭のハイフン、スラッシュを除いたものです。</param>
        /// <param name="必須である">このコマンドを指定することが必須である。</param>
        /// <param name="エイリアスリスト">コマンドキーの代わりに指定し、同じ動作をするコマンドのリスト。</param>
        public コマンド(string コマンドキー, bool 必須である, params string[] エイリアスリスト)
            : this(コマンドキー, 必須である)
        {
            this.エイリアスリスト = エイリアスリスト;
        }

        /// <summary>
        /// >コマンドラインで指定されるコマンドから先頭のハイフン、スラッシュを除いたものを取得します。
        /// </summary>
        public string コマンドキー { get; private set; }

        /// <summary>
        /// このコマンドを指定することが必須であるかどうか表す値を取得します。
        /// </summary>
        public bool 必須である { get; private set; }

        /// <summary>
        /// コマンドキーの代わりに指定し、同じ動作をするコマンドのリストを取得します。
        /// </summary>
        public string[] エイリアスリスト { get; private set; }
    }
}